#ifndef __I_ERRORS_H__
#define __I_ERRORS_H__

#define DEBUG 1

void	DoDebugError(const char * errorDescription, const char * fileName, long lineNumber);
void	DoDebugFatalError(const char * errorDescription, const char * fileName, long lineNumber);

void	DoError(const char * errorDescription);
void	DoFatalError(const char * errorDescription);
void	DoOSErr(const char * errorDescription, OSErr theErr);
void	DoFatalOSErr(const char * errorDescription, OSErr theErr);

#define ASSERT(condition, str)			if(!(condition)) DoError(str)
#define FATAL_ASSERT(condition, str)	if(!(condition)) DoFatalError(str)
#define ERROR(code, str)				if(code) DoOSErr(str, code);
#define FATAL_ERROR(code, str)			if(code) DoFatalOSErr(str, code);

#if DEBUG

	#define DEBUG_ERROR(str)				DoDebugError(str, __FILE__, __LINE__)
	#define DEBUG_FATAL_ERROR(str)			DoDebugFatalError(str, __FILE__, __LINE__)
	#define DEBUG_ASSERT(condition)			if(!(condition)) DoDebugError(#condition, __FILE__, __LINE__)
	#define DEBUG_FATAL_ASSERT(condition)	if(!(condition)) DoDebugFatalError(#condition, __FILE__, __LINE__)

#else

	#define DEBUG_ERROR(str)
	#define DEBUG_FATAL_ERROR(str)
	#define DEBUG_ASSERT(condition)
	#define DEBUG_FATAL_ASSERT(condition)

#endif /* DEBUG */

inline UInt8 HasMacsBug(void)
{
	UInt32	* macJmpPtr = (UInt32 *)0x00000120;
	
	return (*macJmpPtr) != nil;
}

#endif /* __I_ERRORS_H__ */